/** @file   AnimItem.cpp
 * @brief   Implementation of AnimItem class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:48:11 $
 * @author  Tomi Lamminsaari
 */

#include "AnimContainer.h"
#include "DataWarehouse.h"
#include "GraphicsContainer.h"

namespace eng2d {


///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
AnimContainer::AnimContainer()
{
}



/** Destructor.
 */
AnimContainer::~AnimContainer()
{
  for ( int i=0; i < iAnimations.size(); i++ ) {
    delete iAnimations.at(i);
  }
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

void AnimContainer::ResetAndDestroy()
{
  for ( int i=0; i < iAnimations.size(); i++ ) {
    delete iAnimations.at(i);
  }
  iAnimations.clear();
}

void AnimContainer::Push( void* aObject )
{
  Animation* anim = reinterpret_cast<Animation*>( aObject );
  iAnimations.push_back( anim );
}

void* AnimContainer::At( int aUid ) const
{
  if ( aUid < 0 || aUid >= iAnimations.size() ) {
    return 0;
  }
  return iAnimations.at(aUid);
}




///
/// New public methods
/// ============================================================================

/** Assigns the graphics.
 */
int AnimContainer::AssignGraphics( DataWarehouse* aWarehouse )
{
  for ( int i=0; i < iAnimations.size(); i++ ) {
    Animation* anim = iAnimations.at( i );
    int gfxUid = anim->gfxUid();
    if ( gfxUid != KInvalidUid ) {
      GraphicsContainer* gfx = dynamic_cast<GraphicsContainer*>( aWarehouse->Find(gfxUid) );
      if ( gfx == 0 ) {
        return KErrNotFound;
      }
      for ( int j=0; j < anim->frameCount(); j++ ) {
        AnimFrame& frame = anim->at(j);
        frame.setGraphics( gfx->ContentType(),
                           gfx->At(frame.iFrameIndex) );
      }
    }
  }
  return KErrNone;
}




///
/// Getter methods
/// ============================================================================

const Animation& AnimContainer::FindAnim( int aUid ) const throw (xOutOfBounds)
{
  if ( aUid < 0 || aUid >= iAnimations.size() ) {
    throw xOutOfBounds( "AnimItem", "FindAnim(int aUid)" );
  }
  return *(iAnimations.at(aUid));
}



/** Returns the number of animations.
 */
int AnimContainer::AnimationCount() const
{
  return iAnimations.size();
}




///
/// Protected and private methods
/// ============================================================================



}
